/*
SDL_ColorDef by Jonathan Dearborn
See SDL_ColorDef.h for more info.
*/

#include "SDL_ColorDef.h"
#include <malloc.h>

SDL_PixelFormat* RGB_format = NULL;

void RGB_setSurface(SDL_Surface* surf)
{
	if(surf == NULL)
		RGB_setFormat(NULL);
	else
		RGB_setFormat(surf->format);
}

void RGB_setFormat(SDL_PixelFormat* format)
{
	if(format == NULL)
	{
		free(RGB_format);
		RGB_format = NULL;
	}
	else
	{
		if(RGB_format == NULL)
			RGB_format = (SDL_PixelFormat*)malloc(sizeof(SDL_PixelFormat));
		*RGB_format = *format;
	}
}

SDL_PixelFormat* RGB_getFormat(void)
{
    if(RGB_format == NULL)
		RGB_setSurface(SDL_GetVideoSurface());
    return RGB_format;
}
